/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.registry.recipe;

import com.blamejared.crafttweaker.api.recipe.component.IRecipeComponent;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;

public final class RecipeComponentRegistry {
    private final Map<class_2960, IRecipeComponent<?>> components = new HashMap();

    public void registerComponents(Collection<IRecipeComponent<?>> components) {
        if (!this.components.isEmpty()) {
            throw new IllegalStateException("Components have already been registered");
        }
        components.forEach(it -> this.components.put(it.id(), (IRecipeComponent<?>)it));
    }

    public <T> IRecipeComponent<T> find(class_2960 id) {
        return (IRecipeComponent)GenericUtil.uncheck(this.components.computeIfAbsent(id, it -> {
            throw new IllegalArgumentException("No component with id '" + String.valueOf(id) + "' registered; are you too early?");
        }));
    }

    public Collection<IRecipeComponent<?>> allComponents() {
        return Collections.unmodifiableCollection(this.components.values());
    }
}

